import javax.swing.ImageIcon;

public class Ball extends GameObject {

	private int imageWidth;

	public Ball(int x, int y) {
		super(x, y);
		setVelocity(5);
		myImage = new ImageIcon("images/Ball.png");
		imageWidth = myImage.getIconWidth();
	}

	// IMPLEMENTATION OF ABSTRACT METHODS

	public void move(Canvas c) {
		// MOVE BALL AND CHECK FOR A COLLISION WITH WALL
		if (getDirection() == Direction.LEFT) {
			setX(getX() + getVelocity());
			if (getX() + imageWidth > c.getSize().getWidth()) {
				setX((int) (c.getSize().getWidth() - imageWidth));
				setDirection(Direction.RIGHT);
			}

		} else {
			setX(getX() - getVelocity());
			if (getX() < 0) {
				setX(0);

				setDirection(Direction.LEFT);
			}
		}
	}
}
